// MainData.cpp : implementation file
//

#include "stdafx.h"
#include "MainData.h"
#include "Interface.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif




// The time frame: (Order in which each function is called)

// ****************************************************************
// Running the plugin RUNTIME(designer & player)

// Initialization order - done on each page only once per plugin

// SetParentWindow (only on runtime, in Designer it is NULL)
// SetObjRect (if NeedObject)
// SetBuffer1,SetBuffer2,SetBuffer3
// SetInitString
// SetString
// SetPath
// Init
// NextIteration

// Draw - each time MMB needs to draw


// ********************************************************************
// Designer only - passing the parameters to MMB in Plugin Properties:

// Plugin Properties
// SetInitString
// SetString
// GetInfo
// Copyright
// NumOfImages ? Enable the Images buttons
// HasInitDlg ? Enable the Plugin Properties button

// Now if you click the Plugin Properties Button
// SetInitString
// SetString
// Interface
// GetInitString
// GetString




/////////////////////////////////////////////////////////////////////////////
// CMainData
HWND CMainData::m_pParent = NULL;


CMainData::CMainData()
{
	m_pBuffer1 = NULL;
	m_pBuffer2 = NULL;
	m_pBuffer3 = NULL;

//	m_pParent = NULL;

	m_nWidth1 = 0;
	m_nWidth2 = 0;

	m_nHeight1 = 0;
	m_nHeight2 = 0;

	m_nWidth = 0;
	m_nHeight = 0;

	m_nMAINDATA = 0;
	
	Default();
}


void CALLBACK EXPORT TimerProc(
   HWND hWnd,      // handle of CWnd that called SetTimer
   UINT nMsg,      // WM_TIMER
   UINT nIDEvent,   // timer identification
   DWORD dwTime    // system time
)
{

	if (CMainData::m_pParent==NULL)
	{
		::KillTimer(NULL, nIDEvent);
		return;
	}

	if (::IsWindow(CMainData::m_pParent)==0)
	{
		::KillTimer(NULL, nIDEvent);
		return;
	}

	// do timer stuff here 
	CWnd* pWin = CWnd::FromHandle(CMainData::m_pParent);
	if (pWin)
		pWin->Invalidate();

}

CMainData::~CMainData()
{
}



/////////////////////////////////////////////////////////////////////////////
// CMainData message handlers

void CMainData::Default()
{
	color1 = RGB(0,0,255);
	color2 = RGB(0,0,0);
	color3 = RGB(0,255,0);
	color4 = RGB(255,0,0);

	nColType = 0;

	SaveVarToString();

}

//******** MOUSE ******************************
//Does the plugin need the mouse ?
//0 doesn't capture mouse
//1 capture Mouse Up & Mouse Down only;
//2 capture Mouse Move, Mouse Down, Mouse Up
int CMainData::CaptureMouse()
{
	return 1;
}

// Local mouse coordinates - 0...m_nWidth, 0...m_nHeight 
// Relative to the LeftTop of the MMB project window (0,0)
// only if CaptureMouse() is 1 or 2

// Mouse Down
void CMainData::MouseDown(int x, int y)
{

	CString sText;
	sText.Format("Down %d,%d",x,y);
	AfxMessageBox(sText);

}

// Mouse Up
void CMainData::MouseUp(int x, int y)
{
}

// Moving the mouse
void CMainData::MouseMove(int x, int y)
{

}

// Right Button Down
void CMainData::RMouseDown(int x, int y)
{

	CString sText;
	sText.Format("R Down %d,%d",x,y);
	AfxMessageBox(sText);

}

// Right mouse button UP
void CMainData::RMouseUp(int x, int y)
{
}


// ****** Images **********************************
// Does plugin need images ?
// if so we return 1,2 or 3 - how many images the plugin need
// then on plugin properties the Image 1, Image 2 or Image 3 will be enabled
// and user (designer) can load an images (these will be stored in mbd project 
// and the buffers will be passed to the plugin on runtime.

int CMainData::NumOfImages()
{
	return 0;
}

// Now here are buffers passed from MMB into this plugin
void CMainData::SetBuffer1(BYTE * pByte, int nWidth, int nHeight)
{
	m_pBuffer1	= pByte;
	m_nWidth1		= nWidth;
	m_nHeight1	= nHeight;

}

void CMainData::SetBuffer2(BYTE * pByte, int nWidth, int nHeight)
{
	m_pBuffer2	= pByte;
	m_nWidth2		= nWidth;
	m_nHeight2	= nHeight;

}

void CMainData::SetBuffer3(BYTE * pByte, int nWidth, int nHeight)
{
	m_pBuffer3	= pByte;
	m_nWidth3		= nWidth;
	m_nHeight3	= nHeight;


}

// ********** Internal properties dialog ****************************
// Internal Properties dialog - if yes the Plugin Properties Big button will be enabled

//Does it have internal setup data dialog?
int CMainData::HasIntDlg()
{
	return 1; // yes it has so the Properties on designing will call Interface()

}

// Here is the interface to the plugin properties
// All data are stored in one string and the string will be stored in MBD project
// - so we can build general customizable plugins.
// it is up to you how you encode the data into that string
// Here I have one solution to this problem ReadVarFromString and SaveVarToString

char* CMainData::Interface()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState());

	CInterface dlg;
// load it to the string ********
	ReadVarFromString();
//******************************

	dlg.color1 = color1;
	dlg.color2 = color2;
	dlg.color3 = color3;
	dlg.color4 = color4;

	dlg.m_nType = nColType;

	if (dlg.DoModal()==IDOK)
	{

		color1 = dlg.color1;
		color2 = dlg.color2;
		color3 = dlg.color3;
		color4 = dlg.color4;

		nColType = dlg.m_nType;

// save it to the string **********
		SaveVarToString();

	}

	return m_sInterface.GetBuffer(m_sInterface.GetLength());

}


// ******** Parent Window ****************
// the window of the MMB project Window
// Important: In designer the pWnd is always NULL !!!!

void CMainData::SetParentWindow(HWND pWnd)
{
	m_pParent = pWnd;

	if (m_pParent!=NULL)
	{
		// we don't need to do anything here

	}

}


//****** External object coordinates ********************
// if the plugin need some object here we will return the name of the object
char*	CMainData::NeedObject()
{

	return "Object1";

}

// now we will get pointer to the object rectangle
// so we can change its position or size

void CMainData::ObjectRect(CRect* pRect)
{

}


//********* Encoding all variables into one string *************
//
// Note: you might invent your own system
// the idea is - you must store all customizable data into one string
// and the string will be stored in MBD file.
// On runtime the string will be passed back to plugin
// and the plugin must decode the data encoded in that string the same way

// INIT data strings 
// here is the parameter string interface
// all data are in the string with format:
// ~|Var1=2334~|var3=text~|etc=2 

void CMainData::ReadVarFromString()
{
	// extract the items
	int r1 = ReadInt("R1");
	int g1 = ReadInt("G1");
	int b1 = ReadInt("B1");

	color1 = RGB(r1,g1,b1);

	int r2 = ReadInt("R2");
	int g2 = ReadInt("G2");
	int b2 = ReadInt("B2");

	color2 = RGB(r2,g2,b2);

	int r3 = ReadInt("R3");
	int g3 = ReadInt("G3");
	int b3 = ReadInt("B3");

	color3 = RGB(r3,g3,b3);

	int r4 = ReadInt("R4");
	int g4 = ReadInt("G4");
	int b4 = ReadInt("B4");

	color4 = RGB(r4,g4,b4);
	nColType = ReadInt("Typ");

}

// encode the customizable variables into one string to be stored in mbd project
void CMainData::SaveVarToString()
{
	m_sInterface = "";

	m_sInterface+=VarInt("R1",GetRValue(color1));
	m_sInterface+=VarInt("G1",GetGValue(color1));
	m_sInterface+=VarInt("B1",GetBValue(color1));

	m_sInterface+=VarInt("R2",GetRValue(color2));
	m_sInterface+=VarInt("G2",GetGValue(color2));
	m_sInterface+=VarInt("B2",GetBValue(color2));

	m_sInterface+=VarInt("R3",GetRValue(color3));
	m_sInterface+=VarInt("G3",GetGValue(color3));
	m_sInterface+=VarInt("B3",GetBValue(color3));

	m_sInterface+=VarInt("R4",GetRValue(color4));
	m_sInterface+=VarInt("G4",GetGValue(color4));
	m_sInterface+=VarInt("B4",GetBValue(color4));

	m_sInterface+=VarInt("Typ",nColType);

}

CString CMainData::ReadVar(CString siden)
{
	CString sTemp;
	sTemp = "~|" + siden+"=";

	int nLn = sTemp.GetLength();

	int nFind = m_sInterface.Find(sTemp);

	CString sOutput="";

	if (nFind>-1)
	{

		sOutput=m_sInterface.Mid(nFind+nLn);

		int nRight = sOutput.Find("~|");
		if (nRight>-1)
		{
			sOutput = sOutput.Left(nRight);
		}

	}

	return sOutput;

}

int CMainData::ReadInt(CString sIdent)
{
	return atoi(ReadVar(sIdent));

}


CString CMainData::VarInt(CString ident, int nVal)
{
	CString sBuff;

	sBuff.Format("~|%s=%d",ident,nVal);

	return sBuff;

}


CString CMainData::VarString(CString ident, CString nVal)
{
	CString sBuff;

	sBuff.Format("~|%s=%s",ident,nVal);

	return sBuff;

}

// MMB will pass the string on the initialization into the plugin
void CMainData::SetIntString(char * sText)
{
	CString strText(sText);

	if (strText!="")
	{
		m_sInterface = strText;
		ReadVarFromString();
	}
	else
		Default();

}

// The plugin will pass the string into MMB on designing (After Interface command)
char* CMainData::GetIntString()
{
	return m_sInterface.GetBuffer(m_sInterface.GetLength());

}

// Another string you can use, MMB will pass the string to plugin
void CMainData::SetString(char * sString)
{
	CString sText(sString);
	m_sText = sText;

}

// Plugin will pass the string to MMB during designing
char* CMainData::GetString()
{
	return m_sText.GetBuffer(m_sText.GetLength());

}


// ********* Initialization *******************************************
// the initialization, if everything goes well the initialization will take place
// after the command orders:
// Init will be called only once until you go to another page

// SetParentWindow (only on runtime, in Designer it is NULL)
// SetObjRect (if NeedObject)
// SetBuffer1,SetBuffer2,SetBuffer3
// SetInitString
// SetString
// SetPath
// Init <<<<<<<<<<<<<<<<
// NextIteration
// Draw

// nWidth - width of the plugin object on the project window
// nHeight - height of the plugin object on the project window
// xx - x in pixels from the left side of the MMB window
// yy - y 
// Param3, Param4 - not used
void CMainData::Init(int nWidth, int nHeight, int xx, int yy, int Param3, int Param4)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState());

	m_nLeft = xx;
	m_nTop = yy;

	m_nHeight1 = 0;
	m_nHeight2 = 0;

	m_nWidth = nWidth;
	m_nHeight = nHeight;

	m_Buffer.Create(m_nWidth,m_nHeight,32,FALSE);

	BYTE* pBuffer = m_Buffer.GetBits();

	//ASSERT(FALSE);
	double a1 = GetRValue(color1);
	double a2 = GetGValue(color1);
	double a3 = GetBValue(color1);

	double b1 = GetRValue(color2);
	double b2 = GetGValue(color2);
	double b3 = GetBValue(color2);

	double c1 = GetRValue(color3);
	double c2 = GetGValue(color3);
	double c3 = GetBValue(color3);

	double d1 = GetRValue(color4);
	double d2 = GetGValue(color4);
	double d3 = GetBValue(color4);

	// we create the wash buffer

	if (nColType==0)
	{

		double s1 = (b1 - a1)/(double)m_nWidth;
		double s2 = (b2 - a2)/(double)m_nWidth;
		double s3 = (b3 - a3)/(double)m_nWidth;

		double c1,c2,c3;
		for (int y = 0; y< m_nHeight;y++)
		{
			c1 = a1;
			c2 = a2;
			c3 = a3;
			for (int x=0; x<m_nWidth; x++)
			{
				pBuffer[x*4 + y*4*m_nWidth] = c3;
				pBuffer[x*4 + y*4*m_nWidth+1] = c2;
				pBuffer[x*4 + y*4*m_nWidth+2] = c1;
				c1+= s1; c2+= s2; c3+= s3;

			}
		}
	}

	if (nColType==1)
	{

		double s1 = (b1 - a1)/(double)m_nHeight;
		double s2 = (b2 - a2)/(double)m_nHeight;
		double s3 = (b3 - a3)/(double)m_nHeight;

		double c1,c2,c3;
		c1 = a1;
		c2 = a2;
		c3 = a3;

		for (int y = 0; y< m_nHeight;y++)
		{
			for (int x=0; x<m_nWidth; x++)
			{
				pBuffer[x*4 + y*4*m_nWidth] = c3;
				pBuffer[x*4 + y*4*m_nWidth+1] = c2;
				pBuffer[x*4 + y*4*m_nWidth+2] = c1;

			}

			c1+= s1; c2+= s2; c3+= s3;

		}
	}

	if (nColType==2)
	{
		double dconst = m_nWidth*m_nHeight;


		double c1,c2,c3;
		for (int y = 0; y< m_nHeight;y++)
		{
			for (int x=0; x<m_nWidth; x++)
			{
				double dSin = sin(x*y/dconst);
				c1 = (a1*dSin + b1*(1-dSin))/2;
				c2 = (a2*dSin + b2*(1-dSin))/2;
				c3 = (a3*dSin + b3*(1-dSin))/2;

				pBuffer[x*4 + y*4*m_nWidth] = c3;
				pBuffer[x*4 + y*4*m_nWidth+1] = c2;
				pBuffer[x*4 + y*4*m_nWidth+2] = c1;

			}
		}


	}


	if (nColType==3)
	{

		double s1 = (b1 - a1)/(double)m_nHeight;
		double s2 = (b2 - a2)/(double)m_nHeight;
		double s3 = (b3 - a3)/(double)m_nHeight;

		double k1 = (d1 - c1)/(double)m_nWidth;
		double k2 = (d2 - c2)/(double)m_nWidth;
		double k3 = (d3 - c3)/(double)m_nWidth;

		double z1,z2,z3;

		for (int y = 0; y< m_nHeight;y++)
		{
			z1 = c1;
			z2 = c2;
			z3 = c3;
			for (int x=0; x<m_nWidth; x++)
			{
				pBuffer[x*4 + y*4*m_nWidth] = (a3+z3)/2;
				pBuffer[x*4 + y*4*m_nWidth+1] = (a2 +z2)/2;
				pBuffer[x*4 + y*4*m_nWidth+2] = (a1+z1)/2;

				z1+=k1; z2+=k2; z3+=k3;

			}

			a1+= s1; a2+= s2; a3+= s3;

		}

	}


}

// In this version of MMB this is called immediately after Init is done
// so there is no point to use it.
// this is for future development, you don't have to put anything here

void CMainData::NextIteration(float dTime)
{
	

}

// 
void CMainData::Draw(HDC pDC, int x, int y, int nWidth, int nHeight)
{
	m_Buffer.DrawC(CDC::FromHandle(pDC ),x,y,nWidth,nHeight);

}




//***************** SCRIPT interface ***************************************************

// from script PluginSet - integer variable
void CMainData::SetData(int nT)
{
	m_nMAINDATA = nT;
	CString st;
	st.Format("%d",nT);
	AfxMessageBox(st);

}

// from Script PluginGet - integer variable
int CMainData::GetData(void)
{
	
	return 0;
}

// from Script PluginGet - string variable
char* CMainData::GetFile()
{
	CString sText("Test");
	return sText.GetBuffer(sText.GetLength());
}

// from script PluginSet - file or string variable
void CMainData::SetFile(char* file)
{
	CString sText(file);
	AfxMessageBox(sText);
}
