// MainData.cpp : implementation file
//

#include "stdafx.h"
#include "MainData.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// this is sample with client dialog box inside the MMB


// The time frame: (Order in which each function is called)

// ****************************************************************
// Running the plugin RUNTIME(designer & player)

// Initialization order - done on each page only once per plugin

// SetParentWindow (only on runtime, in Designer it is NULL)
// SetObjRect (if NeedObject)
// SetBuffer1,SetBuffer2,SetBuffer3
// SetInitString
// SetString
// SetPath
// Init
// NextIteration

// Draw - each time MMB needs to draw


// ********************************************************************
// Designer only - passing the parameters to MMB in Plugin Properties:

// Plugin Properties
// SetInitString
// SetString
// GetInfo
// Copyright
// NumOfImages ? Enable the Images buttons
// HasInitDlg ? Enable the Plugin Properties button

// Now if you click the Plugin Properties Button
// SetInitString
// SetString
// Interface
// GetInitString
// GetString




/////////////////////////////////////////////////////////////////////////////
// CMainData
HWND CMainData::m_pParent = NULL;


CMainData::CMainData()
{
	m_pEmbWnd = NULL;

	m_pParent = NULL;

	Default();
}


// use with timer - not used in this example
void CALLBACK EXPORT TimerProc(
   HWND hWnd,      // handle of CWnd that called SetTimer
   UINT nMsg,      // WM_TIMER
   UINT nIDEvent,   // timer identification
   DWORD dwTime    // system time
)
{

	if (CMainData::m_pParent==NULL)
	{
		::KillTimer(NULL, nIDEvent);
		return;
	}

	if (::IsWindow(CMainData::m_pParent)==0)
	{
		::KillTimer(NULL, nIDEvent);
		return;
	}

	// do timer stuff here 
	CWnd* pWin = CWnd::FromHandle(CMainData::m_pParent);
	if (pWin)
		pWin->Invalidate();

}

CMainData::~CMainData()
{
	if(m_pEmbWnd)
		delete m_pEmbWnd;
}



/////////////////////////////////////////////////////////////////////////////
// CMainData message handlers

void CMainData::Default()
{

	SaveVarToString();

}

//******** MOUSE ******************************
//Does the plugin need the mouse ?
//0 doesn't capture mouse
//1 capture Mouse Up & Mouse Down only;
//2 capture Mouse Move, Mouse Down, Mouse Up

// We don't have to use mouse in this example because the child dialog box has its own mouse handling
int CMainData::CaptureMouse()
{
	return 0; // no don't use mouse through MMB
}

// Local mouse coordinates - 0...m_nWidth, 0...m_nHeight 
// Relative to the LeftTop of the MMB project window (0,0)
// only if CaptureMouse() is 1 or 2

// Mouse Down
void CMainData::MouseDown(int x, int y)
{

}

// Mouse Up
void CMainData::MouseUp(int x, int y)
{
}

// Moving the mouse
void CMainData::MouseMove(int x, int y)
{

}

// Right Button Down
void CMainData::RMouseDown(int x, int y)
{

	CString sText;
	sText.Format("R Down %d,%d",x,y);
	AfxMessageBox(sText);

}

// Right mouse button UP
void CMainData::RMouseUp(int x, int y)
{
}


// ****** Images **********************************
// Does plugin need images ?
// if so we return 1,2 or 3 - how many images the plugin need
// then on plugin properties the Image 1, Image 2 or Image 3 will be enabled
// and user (designer) can load an images (these will be stored in mbd project 
// and the buffers will be passed to the plugin on runtime.

int CMainData::NumOfImages()
{
	return 0; // no images
}

// Now here are buffers passed from MMB into this plugin

// In this example we don't have any bitmaps
void CMainData::SetBuffer1(BYTE * pByte, int nWidth, int nHeight)
{

}

void CMainData::SetBuffer2(BYTE * pByte, int nWidth, int nHeight)
{

}

void CMainData::SetBuffer3(BYTE * pByte, int nWidth, int nHeight)
{


}

// ********** Internal properties dialog ****************************
// Internal Properties dialog - if yes the Plugin Properties Big button will be enabled

//Does it have internal setup data dialog?
int CMainData::HasIntDlg()
{
	return 0; // No - this is just demo

}

// Here is the interface to the plugin properties
// All data are stored in one string and the string will be stored in MBD project
// - so we can build general customizable plugins.
// it is up to you how you encode the data into that string
// Here I have one solution to this problem ReadVarFromString and SaveVarToString

char* CMainData::Interface()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState());

//	CInterface dlg; // we don't have interface in this example
// load it to the string ********
	ReadVarFromString();
//******************************

//	if (dlg.DoModal()==IDOK)
	{

// save it to the string **********
		SaveVarToString();

	}

	return m_sInterface.GetBuffer(m_sInterface.GetLength());

}


// ******** Parent Window ****************
// the window of the MMB project Window
// Important: In designer the pWnd is always NULL !!!!

void CMainData::SetParentWindow(HWND pWnd)
{
	m_pParent = pWnd;

	// only in Runtime - not in designer!
	if (m_pParent!=NULL)
	{

// Create the Window

		m_pEmbWnd = new CEmbeddedWnd();
		m_pEmbWnd->Create(CWnd::FromHandle(m_pParent));
		m_pEmbWnd->ShowWindow(SW_HIDE);
	}

}


//****** External object coordinates ********************
// if the plugin need some object here we will return the name of the object
char*	CMainData::NeedObject()
{

	return "Object1";

}

// now we will get pointer to the object rectangle
// so we can change its position or size

void CMainData::ObjectRect(CRect* pRect)
{

}


//********* Encoding all variables into one string *************
//
// Note: you might invent your own system
// the idea is - you must store all customizable data into one string
// and the string will be stored in MBD file.
// On runtime the string will be passed back to plugin
// and the plugin must decode the data encoded in that string the same way

// INIT data strings 
// here is the parameter string interface
// all data are in the string with format:
// ~|Var1=2334~|var3=text~|etc=2 

void CMainData::ReadVarFromString()
{

}

// encode the customizable variables into one string to be stored in mbd project
void CMainData::SaveVarToString()
{
	m_sInterface = "";

}

CString CMainData::ReadVar(CString siden)
{
	CString sTemp;
	sTemp = "~|" + siden+"=";

	int nLn = sTemp.GetLength();

	int nFind = m_sInterface.Find(sTemp);

	CString sOutput="";

	if (nFind>-1)
	{

		sOutput=m_sInterface.Mid(nFind+nLn);

		int nRight = sOutput.Find("~|");
		if (nRight>-1)
		{
			sOutput = sOutput.Left(nRight);
		}

	}

	return sOutput;

}

int CMainData::ReadInt(CString sIdent)
{
	return atoi(ReadVar(sIdent));

}


CString CMainData::VarInt(CString ident, int nVal)
{
	CString sBuff;

	sBuff.Format("~|%s=%d",ident,nVal);

	return sBuff;

}


CString CMainData::VarString(CString ident, CString nVal)
{
	CString sBuff;

	sBuff.Format("~|%s=%s",ident,nVal);

	return sBuff;

}

// MMB will pass the string on the initialization into the plugin
void CMainData::SetIntString(char * sText)
{
	CString strText(sText);

	if (strText!="")
	{
		m_sInterface = strText;
		ReadVarFromString();
	}
	else
		Default();

}

// The plugin will pass the string into MMB on designing (After Interface command)
char* CMainData::GetIntString()
{
	return m_sInterface.GetBuffer(m_sInterface.GetLength());

}

// Another string you can use, MMB will pass the string to plugin
void CMainData::SetString(char * sString)
{
	CString sText(sString);
	m_sText = sText;

}

// Plugin will pass the string to MMB during designing
char* CMainData::GetString()
{
	return m_sText.GetBuffer(m_sText.GetLength());

}


// ********* Initialization *******************************************
// the initialization, if everything goes well the initialization will take place
// after the command orders:
// Init will be called only once until you go to another page

// SetParentWindow (only on runtime, in Designer it is NULL)
// SetObjRect (if NeedObject)
// SetBuffer1,SetBuffer2,SetBuffer3
// SetInitString
// SetString
// SetPath
// Init <<<<<<<<<<<<<<<<
// NextIteration
// Draw

// nWidth - width of the plugin object on the project window
// nHeight - height of the plugin object on the project window
// xx - x in pixels from the left side of the MMB window
// yy - y 
// Param3, Param4 - not used
void CMainData::Init(int nWidth, int nHeight, int xx, int yy, int Param3, int Param4)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState());

	m_nLeft = xx;
	m_nTop = yy;

	m_nHeight1 = 0;
	m_nHeight2 = 0;

	m_nWidth = nWidth;
	m_nHeight = nHeight;


	m_bFirstTime = TRUE;

}

// In this version of MMB this is called immediately after Init is done
// so there is no point to use it.
// this is for future development, you don't have to put anything here

void CMainData::NextIteration(float dTime)
{
	

}

// 
void CMainData::Draw(HDC pDC, int x, int y, int nWidth, int nHeight)
{

	AFX_MANAGE_STATE(AfxGetStaticModuleState());
	
	CRect rect(x,y,x+nWidth,y+nHeight);

	CDC* pdc = CDC::FromHandle(pDC );
	pdc->FillSolidRect(rect,RGB(122,255,122));
	pdc->DrawText("On runtime there will be a dialog box (I hope :-)", rect,DT_CENTER | DT_VCENTER | DT_WORDBREAK );

	// On Runtime - we have client window
	// only first time !

	if (m_bFirstTime && m_pEmbWnd)
	{
		m_bFirstTime = FALSE;

		// time to position the window

		CRect rect;
		
		// Move only
		//m_pEmbWnd->GetClientRect(rect);
		//rect.OffsetRect(x,y);

		// Move and resize
		rect = CRect(x,y,x+nWidth,y+nHeight);

		m_pEmbWnd->MoveWindow(rect);

		// And show it !
		m_pEmbWnd->ShowWindow(SW_SHOW);

	}



}




//***************** SCRIPT interface ***************************************************

// from script PluginSet - integer variable
void CMainData::SetData(int nT)
{
	m_nMAINDATA = nT;
	CString st;
	st.Format("%d",nT);
	AfxMessageBox(st);

}

// from Script PluginGet - integer variable
int CMainData::GetData(void)
{
	
	return 0;
}

// from Script PluginGet - string variable
char* CMainData::GetFile()
{
	CString sText("Test");
	return sText.GetBuffer(sText.GetLength());
}

// from script PluginSet - file or string variable
void CMainData::SetFile(char* file)
{
	CString sText(file);
	AfxMessageBox(sText);
}
