// MainData.cpp : implementation file
//

#include "stdafx.h"
#include "MainData.h"
#include "Interface.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainData

// This example shows how to use Timers in multi-instances
// The plugin is multi-instance ready -you can put few of the same plugin into one
// page and all of them will use it's own timer and separate parameters.

// Global Array of pointers to current instance of MainData
CPtrArray m_PtrArray;


HWND CMainData::m_pParent = NULL;

//CMainData* CMainData::m_pThis = NULL;

CMainData::CMainData()
{
	m_pEmbWnd = NULL;

	m_pParent = NULL;

	m_nWidth = 0;
	m_nHeight = 0;

	m_nMAINDATA = 0;
	

	nTimerID = 0;

	mR = NULL;
	mG = NULL;
	mB = NULL;

    blobField = NULL;
    blobScreen = NULL;
    xblob = NULL;
    yblob = NULL;
    dxblob = NULL;
    dyblob = NULL;
 
	Default();
}


void CALLBACK EXPORT TimerProc(
   HWND hWnd,      // handle of CWnd that called SetTimer
   UINT nMsg,      // WM_TIMER
   UINT nIDEvent,   // timer identification
   DWORD dwTime    // system time
)
{

	// now check from which instance of Main Data is the event
	CMainData* pObj = NULL;
	for (int n=0; n< m_PtrArray.GetSize(); n++)
	{

		pObj = (CMainData*)m_PtrArray.GetAt(n);
		if (pObj)
		{
			// We found the instance - so call next iteration
			if (pObj->nTimerID==nIDEvent)
			{
				pObj->NextIteration(0);
			}
		}

	}

	if (CMainData::m_pParent==NULL)
	{
		::KillTimer(NULL, nIDEvent);
		return;
	}

	if (::IsWindow(CMainData::m_pParent)==0)
	{
		::KillTimer(NULL, nIDEvent);
		return;
	}

	// Invalidate the Parent (MMB window)
	CWnd* pWin = CWnd::FromHandle(CMainData::m_pParent);
	if (pWin)
		pWin->Invalidate();

}

CMainData::~CMainData()
{
	if (nTimerID!=0)
		::KillTimer(NULL, nTimerID);

	if(m_pEmbWnd)
		delete m_pEmbWnd;

	if (mR)
		delete mR;

	if (mG)
		delete mG;
	if (mB)
		delete mB;


    if (blobField)
		delete blobField;
    
	if (blobScreen)
		delete blobScreen;

    if (xblob)
		delete xblob;

    if (yblob)
		delete yblob;
    if (dxblob)
		delete dxblob;
    if (dyblob)
		delete dyblob;

}



/////////////////////////////////////////////////////////////////////////////
// CMainData message handlers

// Default data (without setting the properties)

void CMainData::Default()
{
	color1 = RGB(0,0,255);
	color2 = RGB(0,0,0);
	color3 = RGB(0,255,0);
	color4 = RGB(255,0,0);

	nColType = 0;

	m_nSizeOfBlob = 64;

	SaveVarToString();

}
//Does need the mouse ?
//0 doesn't capture mouse
//1 capture Mouse Up & Mouse Down only;
//2 capture Mouse Move, Mouse Down, Mouse Up

int CMainData::CaptureMouse()
{
	return 0;
}

// Does need images ?
int CMainData::NumOfImages()
{
	return 0; // no images
}


//Does it have internal setup data dialog?
int CMainData::HasIntDlg()
{
	return 1;

}

//****** External object coordinates
char*	CMainData::NeedObject()
{

	return "Object1";

}

//pass pointers to the external Object
void CMainData::ObjectRect(CRect* pRect)
{

}

// local mouse points - 0...m_nWidth, 0...m_nHeight
// only if CaptureMouse() is 1 or 2

void CMainData::MouseDown(int x, int y)
{
/*
	CString sText;
	sText.Format("Down %d,%d",x,y);
	AfxMessageBox(sText);
*/
}
// local mouse points - 0...m_nWidth, 0...m_nHeight
// only if CaptureMouse() is 1 or 2

void CMainData::MouseUp(int x, int y)
{
}

// local mouse points - 0...m_nWidth, 0...m_nHeight
// only if CaptureMouse() is 2

void CMainData::MouseMove(int x, int y)
{

}

void CMainData::RMouseDown(int x, int y)
{
}
// local mouse points - 0...m_nWidth, 0...m_nHeight
// only if CaptureMouse() is 1 or 2

void CMainData::RMouseUp(int x, int y)
{
}

//INIT data strings 
// here is the parameter string interface
// all data are in the string with format:
// ~|Var1=2334~|var3=text~|etc=2 

void CMainData::ReadVarFromString()
{
	m_nSizeOfBlob = ReadInt("Blob");

}

// decode variables into the string
void CMainData::SaveVarToString()
{
	m_sInterface = "";

	m_sInterface+=VarInt("Blob",m_nSizeOfBlob);

}

char* CMainData::Interface()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState());

	CInterface dlg;
// load it to the string ********
	ReadVarFromString();
//******************************

	dlg.m_nSizeOfBlob = m_nSizeOfBlob;

	if (dlg.DoModal()==IDOK)
	{

		m_nSizeOfBlob = dlg.m_nSizeOfBlob;
// save it to the string **********
		SaveVarToString();

	}

	return m_sInterface.GetBuffer(m_sInterface.GetLength());

}

void CMainData::SetBuffer1(BYTE * pByte, int nWidth, int nHeight)
{

}

void CMainData::SetBuffer2(BYTE * pByte, int nWidth, int nHeight)
{

}

void CMainData::SetBuffer3(BYTE * pByte, int nWidth, int nHeight)
{

}

void CMainData::Init(int nWidth, int nHeight, int xx, int yy, int Param3, int Param4)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState());

	m_nLeft = xx;
	m_nTop = yy;

	m_nWidth = nWidth;
	m_nHeight = nHeight;

	m_Buffer.Create(m_nWidth,m_nHeight,32,FALSE);

	BYTE* pBuffer = m_Buffer.GetBits();

    mR = new byte[256];
    mG = new byte[256];
    mB = new byte[256];

	bSize = m_nSizeOfBlob;
    SpotSize = 1;
    int w = m_nWidth / SpotSize;
    int h = m_nHeight / SpotSize;
    blobField = new BYTE[bSize * bSize];
    blobScreen = new BYTE[w * h];
    numBlobs = 10;
    xblob = new float[numBlobs];
    yblob = new float[numBlobs];
    dxblob = new float[numBlobs];
    dyblob = new float[numBlobs];
    xblob[0] = 40;
    yblob[0] = 40;
    dxblob[0] = 0.25;
    dyblob[0] = 1.0;
    xblob[1] = 66;
    yblob[1] = 50;
    dxblob[1] = 1.0;
    dyblob[1] = -0.75;
    xblob[2] = bSize / 2;
    yblob[2] = bSize / 2;
    dxblob[2] = -0.75;
    dyblob[2] = 0.5;
    xblob[3] = w - bSize / 2;
    yblob[3] = h - bSize / 2;
    dxblob[3] = -0.54;
    dyblob[3] = 1.1;
    xblob[4] = w - bSize / 2;
    yblob[4] = h - bSize / 2;
    dxblob[4] = 0.97;
    dyblob[4] = -0.99;
    xblob[5] = w - bSize / 2;
    yblob[5] = bSize / 2;
    dxblob[5] = -0.79;
    dyblob[5] = 0.23;
    xblob[6] = bSize / 2;
    yblob[6] = h - bSize / 2;
    dxblob[6] = 0.37;
    dyblob[6] = -0.65;
    xblob[7] = bSize / 2;
    yblob[7] = h - bSize / 2;
    dxblob[7] = 0.27;
    dyblob[7] = -0.85;
    xblob[8] = bSize / 2;
    yblob[8] = h - bSize / 2;
    dxblob[8] = 0.47;
    dyblob[8] = 0.65;
    xblob[9] = bSize / 2;
    yblob[9] = h - bSize / 2;
    dxblob[9] = 0.57;
    dyblob[9] = -0.25;
	PrepareCLS();
	createShadeBlob();

	// We have to put the instance into the array - because the TimerProc is global

	if (m_pParent!=NULL)
	{
		nTimerID = ::SetTimer(NULL, 0, 100, TimerProc);
		m_PtrArray.Add(this);
	}
			

	//ASSERT(FALSE);
}

void CMainData::NextIteration(float dTime)
{
	if (mR==NULL)
		return;

	BYTE* pBuffer = m_Buffer.GetBits();
	int w = m_nWidth;
	int h  = m_nHeight;

    int i = 1;

    int i1 = bSize / 2;
    int k1 = bSize / 2;
    int l = w - bSize / 2;
    int j1 = h - bSize / 2;
    ZeroMemory(blobScreen,m_nWidth*m_nHeight);
    for(int j = 0; j < numBlobs; j++)
    {
        xblob[j] += dxblob[j] * (float)i;
        yblob[j] += dyblob[j] * (float)i;
        if(xblob[j] >= (float)l)
        {
            xblob[j] = (float)l - (xblob[j] - (float)l);
            dxblob[j] = -dxblob[j];
        }
        if(xblob[j] < (float)i1)
        {
            xblob[j] = (float)i1 - (xblob[j] - (float)i1);
            dxblob[j] = -dxblob[j];
        }
        if(yblob[j] >= (float)j1)
        {
            yblob[j] = (float)j1 - (yblob[j] - (float)j1);
            dyblob[j] = -dyblob[j];
        }
        if(yblob[j] < (float)k1)
        {
            yblob[j] = (float)k1 - (yblob[j] - (float)k1);
            dyblob[j] = -dyblob[j];
        }
        //if((j & 0x1) == 0)
            putBob((int)xblob[j], (int)yblob[j]);
        //else
          // subBob((int)xblob[j], (int)yblob[j]);
    }

	for (int y = 0; y<m_nHeight*m_nWidth; y++)
	{

		pBuffer[y*4] = mB[blobScreen[y]];
		pBuffer[y*4+1] = mG[blobScreen[y]];
		pBuffer[y*4+2] = mR[blobScreen[y]];

	}

}

void CMainData::Draw(HDC pDC, int x, int y, int nWidth, int nHeight)
{
	m_Buffer.DrawC(CDC::FromHandle(pDC ),x,y,nWidth,nHeight);

}


// in designer pWnd is NULL !!!!
void CMainData::SetParentWindow(HWND pWnd)
{
	m_pParent = pWnd;

	if (m_pParent!=NULL)
	{
	}

}



int CMainData::GetData()
{
	return m_nMAINDATA;

}

void CMainData::SetData(int nT)
{
	m_nMAINDATA = nT;
	CString st;
	st.Format("%d",nT);
	AfxMessageBox(st);

}


void CMainData::SetIntString(char * sText)
{
	CString strText(sText);

	if (strText!="")
	{
		m_sInterface = strText;
		ReadVarFromString();
	}
	else
		Default();

}

char* CMainData::GetIntString()
{
	return m_sInterface.GetBuffer(m_sInterface.GetLength());

}

void CMainData::SetString(char * sString)
{
	CString sText(sString);
	m_sText = sText;

}

char* CMainData::GetString()
{
	return m_sText.GetBuffer(m_sText.GetLength());

}

CString CMainData::ReadVar(CString siden)
{
	CString sTemp;
	sTemp = "~|" + siden+"=";

	int nLn = sTemp.GetLength();

	int nFind = m_sInterface.Find(sTemp);

	CString sOutput="";

	if (nFind>-1)
	{

		sOutput=m_sInterface.Mid(nFind+nLn);

		int nRight = sOutput.Find("~|");
		if (nRight>-1)
		{
			sOutput = sOutput.Left(nRight);
		}

	}

	return sOutput;

}

int CMainData::ReadInt(CString sIdent)
{
	return atoi(ReadVar(sIdent));

}


CString CMainData::VarInt(CString ident, int nVal)
{
	CString sBuff;

	sBuff.Format("~|%s=%d",ident,nVal);

	return sBuff;

}


CString CMainData::VarString(CString ident, CString nVal)
{
	CString sBuff;

	sBuff.Format("~|%s=%s",ident,nVal);

	return sBuff;

}


char* CMainData::GetFile()
{
	return m_sFile.GetBuffer(m_sFile.GetLength());
}

void CMainData::SetFile(char* file)
{
	CString sText(file);
	m_sFile = sText;
}

void CMainData::PrepareCLS()
{
    for(int i = 0; i < 256; i++)
    {
        mR[i] = 0;
        mG[i] = 0;
        mB[i] = 0;
    }

    for(int j = 0; j < 32; j++)
        mG[16 + j] = (byte)(j * 4);

    for(int k = 0; k < 32; k++)
        mG[48 + k] = (byte)(128 - k * 4);

    for(int l = 0; l < 16; l++)
    {
        mR[80 + l] = (byte)(l * 16);
        mG[80 + l] = 0;
    }

    for(int i1 = 0; i1 < 16; i1++)
    {
        mR[96 + i1] = -1;
        mG[96 + i1] = (byte)(i1 * 16);
    }

    for(int j1 = 0; j1 < 16; j1++)
    {
        mR[112 + j1] = 255;
        mG[112 + j1] = 255;
        mB[112 + j1] = (BYTE)(j1 * 16);
    }

    for(int k1 = 0; k1 < 16; k1++)
    {
        mB[128 + k1] = 255;
        mG[128 + k1] = 255;
        mR[128 + k1] = 255;
    }

    for(int l1 = 0; l1 < 16; l1++)
    {
        mB[143 - l1] = 255;
        mG[143 - l1] = (byte)(l1 * 16);
        mR[143 - l1] = 255;
    }

    for(int i2 = 0; i2 < 32; i2++)
    {
        mB[175 - i2] = (BYTE)(i2 * 8);
        mR[175 - i2] = (BYTE)(i2 * 8);
    }

    for(int j2 = 0; j2 < 32; j2++)
        mB[175 + j2] = (BYTE)(j2 * 4);

    for(int k2 = 0; k2 < 32; k2++)
        mB[207 + k2] = (BYTE)(128 - k2 * 4);
}

BYTE CMainData::BlobFunc(int i, int j)
{
    int k1 = 0;
    int k = i - bSize / 2;
    int l = j - bSize / 2;
    int i1 = k * k + l * l;
    int l1 = (bSize / 2) * (bSize / 2);
    if(i1 < l1)
    {
        int j1 = 1024 - (1024 * i1) / l1;
        k1 += j1 * j1;
    }
    k1 >>= 13;
	int nRet = (k1 - 1);
	if (nRet<0)
		nRet = 0;
	nRet = nRet & 255;
    return (BYTE)nRet;
}


void CMainData::createShadeBlob()
{
    for(int j = 0; j < bSize; j++)
    {
        for(int i = 0; i < bSize; i++)
            blobField[i + j * bSize] = BlobFunc(i, j);

    }

}


void CMainData::putBob(int i, int j)
{
	//return;

    int i1 = 0;
	int nSizer = (m_nWidth* m_nHeight);
	int nSizeT = (bSize * bSize);

    int k1 = (i - bSize / 2) + (j - bSize / 2) * m_nWidth;
    for(int k = 0; k < bSize; k++)
    {
        for(int l = 0; l < bSize; l++)
        {
            int j1;
			if (i1<nSizeT && k1<nSizer)
				j1= blobScreen[k1] + blobField[i1++];

            if(j1 > 255)
				j1 = 255;

            if(j1 < 0)
				j1 = 0;

			if (k1<nSizer)
				blobScreen[k1++] = (BYTE)(j1 & 255);
        }

        k1 += m_nWidth - bSize;
    }

}

