#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers

//#include <windows.h>
#include <stdio.h>
#include <tchar.h>

#define BLUE_PIXEL 0
#define GREEN_PIXEL 1
#define RED_PIXEL 2

typedef unsigned char BYTE;

BYTE* m_pBuffer;	// The main display buffer
BYTE* m_pBuffIn;	// buffer with the first image (from page)
BYTE* m_pBuffOut;	// buffer with the second image (to page)

int m_nWidth; // Width of the screen
int m_nHeight; // Height of the screen

int m_nType; // You can have more transitions inside one dll. <0....many>

// Important NOTE:
// Buffers (m_pBuffer,m_pBuffIn,m_pBuffOut) in the transition plugin 
// are 4 Bytes per pixel:
// Blue , Green, Red, Empty
// -----------------
// | B | G | R | x |
// -----------------
// It means the buffer size is m_nWidth*m_nHeight*4
// Then if you want to address pixel in [x,y] posittion you use:
// m_pBuffer[ y * m_nWidth * 4 + x * 4 ]
// Since you have to do it for all B,G,R pixels you use:

// m_pBuffer[ y * m_nWidth * 4 + x * 4 ]    // BLUE pixel
// m_pBuffer[ y * m_nWidth * 4 + x * 4 + 1] // GREEN pixel
// m_pBuffer[ y * m_nWidth * 4 + x * 4 + 2] // RED pixel

// this is very important!
// Don't forgot the x and y must be (0 or bigger) and smaller than m_nWidth and m_nHeight
// if (x<0 || x>m_nWidth-1 || y<0 || y>m_nHeight-1) BAD, don't do any buffer operations!
// OTHERWISE YOU CAN CRASH THE MMB

// The buffer starts from bottom screen to the top
// the "zero" is in bottom left corner of the screen !

// The info which will appear in the Transition Plug-In dialog box in MMB
extern "C" __declspec(dllexport) char* GetInfo()
{
	return "This is just example for transition Plug-In.\n\nTransition plug-in can have more than just one transition (look at the combo-box)";
}

extern "C" __declspec(dllexport) char* Copyright()
{
	return "(c) Oscar 1999";
}


// You can have many different transitions inside one dll
// This method will give the user the choice which transition he wants to use
// MMB designer call this to fill up the combo-box.
extern "C" __declspec(dllexport) char* GetChoices()
{
	return "Alpha Blend Transition |Simple Wash from bottom|Simple Wash from top|From Top & Bottom";
}


// Buffers received from MMB.
// you shouldn't pot anything else here
extern "C" __declspec(dllexport) void SetBuffer(BYTE* pByte)
{
	m_pBuffer = pByte;

}

extern "C" __declspec(dllexport) void SetBufferIn(BYTE* pByte)
{
	m_pBuffIn = pByte;

}

extern "C" __declspec(dllexport) void SetBufferOut(BYTE* pByte)
{
	m_pBuffOut = pByte;

}

// ********************************************************************************
//
// MAIN function - Next iteration - the worker
// MMB will call this function periodically in the time of transition
// the dTimer is a value between 0..1, telling me how far is the transition.
// what you need to do is to fill the m_pBuffer with the transition image between
// m_pBuffIn and m_pBuffOut
//
// Look at the note on the top of this file for the buffer sizes
// Just reminder: if you want to address pixel in [x,y] posittion you use:
// m_pBuffer[ y * m_nWidth * 4 + x * 4 ]

extern "C" __declspec(dllexport) void Next(float dTimer)
{

	switch(m_nType)
	{
	case 0: // The alpha blend transition
		{
			int alpha = dTimer*255;
			int negalpha = 255-alpha;

			int nLine = m_nWidth*4; // this is a size of the line in bytes

			// loop through all lines (y) and columns (x)
			for (int y = 0; y<m_nHeight; y++)
			{ 
				for (int x = 0; x<m_nWidth; x++)
				{ 
					// I calculated m_nWidth*4 before the loop because this is the same all the time
					// it is the old:  y * m_nWidth * 4 + x * 4 

					int nPos = y*nLine+x*4;

					// This is how the Alpha blend is calculated:
					// in mathematical formula it is:
					// dest = src1*(1-alpha)+ src2*alpha; where alpha is from 0 to 1
					
					// I want to get some more speed so I am avoiding the float calculation
					// I multiply the alpha by 256 on the beginning
					// and here I use bit shift >> 8 which in other meaning is the same like divison by 255
					// Integer arithmetic is MUCH faster than floating point arithmetic!

					// sure I must do it three times for all B,G,R pixels

					m_pBuffer[nPos  ] =	(m_pBuffIn[nPos  ]*negalpha+m_pBuffOut[nPos  ]*alpha)>>8;
					m_pBuffer[nPos+1] = (m_pBuffIn[nPos+1]*negalpha+m_pBuffOut[nPos+1]*alpha)>>8;
					m_pBuffer[nPos+2] = (m_pBuffIn[nPos+2]*negalpha+m_pBuffOut[nPos+2]*alpha)>>8;
				  
				}
			}

			
		}
		break;
	
	case 1: //Simple Bottom Wash
		{
		
			// in many cases you don't have to loop over the all pixels.
			// you can manipulate the buffer with memcpy and buffer arithmetics
			// this is faster than the loop!

			// Note: on the beginning the image m_pBuffIn is in the m_pBuffer
			// so we don't care about that, we just covering it with m_pBuffOut
			// Note2: as it is written on the top of this file the Transitions buffers 
			// starts on the bottom of the screen to the top

			int LinesToCopy = m_nHeight*dTimer; // how many lines in this iteration

			int nBytesToCopy = m_nWidth*4*LinesToCopy;// this means how many bytes to copy
			
			int nMaxBytes = m_nWidth*m_nHeight*4; // this is the maximum bytes, the size of the buffer

			// this will be OK, but just in case ....
			if (nBytesToCopy<=nMaxBytes)	
			{
				memcpy(m_pBuffer, m_pBuffOut, nBytesToCopy);
			}
		}
		break;
	case 2: // Wash from top
		{
			// this is very much like the code above
			int LinesToCopy = m_nHeight*dTimer; 
			int nBytesToCopy = m_nWidth*4*LinesToCopy;
			
			int nMaxBytes = m_nWidth*m_nHeight*4; 

			int nOffset = nMaxBytes - nBytesToCopy;
			
			// the only difference is here
			if (nOffset+nBytesToCopy<=nMaxBytes)	
			{
				memcpy(m_pBuffer + nOffset, m_pBuffOut + nOffset, nBytesToCopy);
				// if you asking what is the m_pBuffer + nOffset doing, 
				// this are the pointer operations in c++
				// I am just setting the pointer to the buffer about nOffset forward
				// (some number of lines ahead)

			}
	
		}
		break;
	case 3: // Combination of the code 1 and 2
		{
			
			// We use the code above to create a new transition
			// the other transitions we have seen already in MMB
			// but this is a brand new one :-)

			int LinesToCopy = m_nHeight*(dTimer/2); // do it only half way

			int nBytesToCopy = m_nWidth*4*LinesToCopy;
			
			int nMaxBytes = m_nWidth*m_nHeight*4; 

			int nOffset = nMaxBytes - nBytesToCopy;
			
			// do the bottom
			if (nBytesToCopy<=nMaxBytes)	
			{
				memcpy(m_pBuffer, m_pBuffOut, nBytesToCopy);
			}

			// do the top
			if (nOffset+nBytesToCopy<=nMaxBytes)	
			{
				memcpy(m_pBuffer + nOffset, m_pBuffOut + nOffset, nBytesToCopy);

			}
	
		}
		break;

	} 
}

// MMB will call this to set the Width and Height
extern "C" __declspec(dllexport) void SetDim(int nWidth, int nHeight)
{
	m_nWidth = nWidth;
	m_nHeight = nHeight;

}

// MMB will call this to set the transition type
// see char* GetChoices()
extern "C" __declspec(dllexport) void SetType(int nType)
{
	m_nType = nType;

}
